package com.burhanstore.neonbubblequest.act

import android.app.Activity
import android.app.Dialog
import android.content.ClipData
import android.content.ClipboardManager
import android.content.Context
import android.content.Intent
import android.graphics.Color
import android.graphics.drawable.Drawable
import android.os.Bundle
import android.util.Log
import android.view.Gravity
import android.view.View
import android.view.Window
import android.view.WindowManager
import android.view.animation.AccelerateInterpolator
import android.view.animation.DecelerateInterpolator
import android.widget.Button
import android.widget.Toast
import androidx.appcompat.app.AppCompatActivity
import androidx.core.graphics.drawable.toDrawable
import androidx.lifecycle.lifecycleScope
import com.bumptech.glide.Glide
import com.bumptech.glide.load.DataSource
import com.bumptech.glide.load.engine.GlideException
import com.bumptech.glide.request.RequestListener
import com.burhanstore.neonbubblequest.R
import com.burhanstore.neonbubblequest.SplashActivity
import com.burhanstore.neonbubblequest.Utils.AppString
import com.burhanstore.neonbubblequest.Utils.DialogManager
import com.burhanstore.neonbubblequest.Utils.anim.AnimationHelper
import com.burhanstore.neonbubblequest.Utils.anim.setClick
import com.burhanstore.neonbubblequest.Utils.appuser.UserManager
import com.burhanstore.neonbubblequest.Utils.network.AppNetworkAdapter
import com.burhanstore.neonbubblequest.databinding.ActivityProfileBinding
import com.google.gson.JsonObject

class ProfileActivity : AppCompatActivity() {


    private lateinit var binding: ActivityProfileBinding
    private lateinit var activity: Activity

    private var uid: String = ""

    private lateinit var user_m: UserManager
    private var dialog_claim: Dialog? = null


    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = ActivityProfileBinding.inflate(layoutInflater)
        setContentView(binding.root)
        activity = this


        DialogManager.initDialog(activity)
        binding.imageView2.setClick { finish() }

        user_m = UserManager.getInstance(activity)
        uid = user_m.getUser()?.u_id ?: ""
        val json_reader = AppString.JsonReader(user_m.getSetting()?.app_config ?: "")



        binding.fullname.text = user_m.getUser()?.name
        binding.refer.text = user_m.getUser()?.refer
        binding.imageView5.setClick {
            val clipboard = getSystemService(Context.CLIPBOARD_SERVICE) as ClipboardManager
            val clip = ClipData.newPlainText("Copied Text", user_m.getUser()?.refer)
            clipboard.setPrimaryClip(clip)
            Toast.makeText(this, "Copied to clipboard!", Toast.LENGTH_SHORT).show()
        }


        activity.let { Glide.with(it) }
            .load(user_m.getUser()?.image)
            ?.centerCrop()
            ?.placeholder(R.drawable.app_icon)
            ?.listener(object : RequestListener<Drawable> {
                override fun onLoadFailed(
                    e: GlideException?,
                    model: Any?,
                    target: com.bumptech.glide.request.target.Target<Drawable>,
                    isFirstResource: Boolean
                ): Boolean {
                    return false
                }

                override fun onResourceReady(
                    resource: Drawable,
                    model: Any,
                    target: com.bumptech.glide.request.target.Target<Drawable>?,
                    dataSource: DataSource,
                    isFirstResource: Boolean
                ): Boolean {
                    return false
                }
            })?.into(binding.Userdp)


        //action
        binding.accountHBtn.setClick {
            val intent = Intent(activity, EarnHActivity::class.java)
            startActivity(intent)
            AnimationHelper.applySlideZoomTransition(activity)
        }

        binding.myReBtn.setClick {
            val intent = Intent(activity, RedeemsActivity::class.java)
            startActivity(intent)
            AnimationHelper.applySlideZoomTransition(activity)
        }


        binding.trBtn.setClick {
            val intent = Intent(activity, PageViewActivity::class.java).apply {
                putExtra("page_name", user_m.getSetting()?.terms_title)
                putExtra("page_content", user_m.getSetting()?.terms_desc)
            }
            startActivity(intent)
            AnimationHelper.applySlideZoomTransition(activity)
        }

        binding.prBtn.setClick {
            val intent = Intent(activity, PageViewActivity::class.java).apply {
                putExtra("page_name", user_m.getSetting()?.privacy_title)
                putExtra("page_content", user_m.getSetting()?.privacy_desc)
            }
            startActivity(intent)
            AnimationHelper.applySlideZoomTransition(activity)
        }


        binding.getHelpBtn.setClick {

            val emailIntent = Intent(Intent.ACTION_SEND).apply {
                type = "message/rfc822"
                putExtra(Intent.EXTRA_EMAIL, arrayOf(json_reader.get("support_email")))
                putExtra(Intent.EXTRA_SUBJECT, "Need Help with My Account")
                putExtra(
                    Intent.EXTRA_TEXT,
                    "Hello, I am facing an issue with... u_id : ${user_m.getUser()?.u_id ?: "User"}"
                )
            }
            try {
                startActivity(Intent.createChooser(emailIntent, "Choose Email App"))
            } catch (ex: android.content.ActivityNotFoundException) {
                Toast.makeText(activity, "No email app found.", Toast.LENGTH_SHORT).show()
            }

        }
        binding.deleteBtn.setClick {
            delete_dialog()
        }


    }


    private fun delete_dialog() {

        dialog_claim = Dialog(activity).apply {
            requestWindowFeature(Window.FEATURE_NO_TITLE)
            setContentView(R.layout.delete_dialog)
            setCancelable(true)
            window?.apply {
                setBackgroundDrawable(Color.TRANSPARENT.toDrawable())
                setGravity(Gravity.BOTTOM)
                attributes = attributes?.apply {
                    width = WindowManager.LayoutParams.MATCH_PARENT
                    height = WindowManager.LayoutParams.WRAP_CONTENT
                }
                addFlags(WindowManager.LayoutParams.FLAG_DIM_BEHIND)
                setDimAmount(0.4f)
            }
        }
        val rootView = dialog_claim?.findViewById<View>(R.id.dialog_root)
        val positive_button = dialog_claim?.findViewById<Button>(R.id.positive_button)
        val negative_button = dialog_claim?.findViewById<Button>(R.id.negative_button)

        rootView?.apply {
            translationY = 300f
            alpha = 0f
            animate()
                .translationY(0f)
                .alpha(1f)
                .setDuration(400)
                .setInterpolator(DecelerateInterpolator())
                .start()
        }

        // close
        positive_button?.setClick {
            dialog_claim!!.dismiss()
        }


        // close
        negative_button?.setClick {

            DialogManager.showDialog()
            val json = JsonObject().apply {
                addProperty("action", "delete_account")
                addProperty("u_id", user_m.getUser()?.u_id)
            }

            AppNetworkAdapter.sendRequest(
                lifecycleScope,
                json,
                object : AppNetworkAdapter.ResponseHandler {
                    override fun onSuccess(response: JsonObject?) {
                        Log.d("SplashActivity", "Success: $response")

                        cacheDir?.deleteRecursively()
                        filesDir?.deleteRecursively()
                        getSharedPreferences("app_cache", Context.MODE_PRIVATE)?.edit()
                            ?.clear()?.apply()
                        getSharedPreferences("your_prefs_name", Context.MODE_PRIVATE)
                            ?.edit()
                            ?.clear()?.apply()
                        databaseList()?.forEach { db ->
                            deleteDatabase(db)
                        }
                        val intent = Intent(activity, SplashActivity::class.java).apply {
                            addFlags(Intent.FLAG_ACTIVITY_NEW_TASK or Intent.FLAG_ACTIVITY_CLEAR_TASK)
                        }
                        startActivity(intent)
                        DialogManager.dismissDialog()
                    }

                    override fun onError(code: Int, message: String?) {
                        Log.e("SplashActivity", "Error $code: $message")

                    }

                    override fun onException(exception: Exception) {
                        Log.e("SplashActivity", "Exception: ", exception)

                    }
                })




            rootView?.animate()
                ?.translationY(300f)
                ?.alpha(0f)
                ?.setDuration(300)
                ?.setInterpolator(AccelerateInterpolator())
                ?.withEndAction { dialog_claim?.dismiss() }
                ?.start()
        }



        runCatching {
            dialog_claim?.isShowing?.let { if (!it) dialog_claim?.show() }
        }.onFailure { it.printStackTrace() }


    }


}